using System;

using DarkStrideToolbox;


namespace DarkStride.StellarLanes.Client
{
	public class Profile
	{
		#region Properties
		private string m_sName = "";
		#endregion


		public Profile()
		{
		}


		public void LoadFromFile( string sFileName )
		{
			string sFile = "";
			
			
			sFile = DSMisc.GetFile( sFileName );
			DeSerialize( sFile );
		}
		public void SaveToFile()
		{
			DSMisc.PutFile( GetFileName(),Serialize() );
		}
		public string GetFileName()
		{
			string sRetVal = "";
			string sFileName = "";


			sFileName = m_sName;

			sRetVal = DSMisc.GetDevelopmentAppPath() + sFileName + ".DAT";


			return( sRetVal );
		}


		public string Serialize()
		{
			string sRetVal = "";
			DSSerialize oSerialize = new DSSerialize();


			//Now save our data
			oSerialize.Set( 0,m_sName );
			sRetVal = oSerialize.Serialize();


			return( sRetVal );
		}
		public void DeSerialize( string sProfile )
		{
			DSSerialize oSerialize = new DSSerialize();


			oSerialize.DeSerialize( sProfile );

			m_sName = oSerialize.GetString( 0 );
		}



		#region Properties
		public string Name
		{
			get
			{
				return( m_sName );
			}
			set
			{
				m_sName = value;
			}
		}
		#endregion
	}
}
